{
  lib,
  stdenv,
  fetchurl,
  gettext,
}:

# Note: this package is used for bootstrapping fetchurl, and thus
# cannot use fetchpatch! All mutable patches (generated by GitHub or
# cgit) that are needed here should be included directly in Nixpkgs as
# files.

stdenv.mkDerivation rec {
  pname = "attr";
  version = "2.5.2";

  src = fetchurl {
    url = "mirror://savannah/attr/attr-${version}.tar.gz";
    sha256 = "sha256-Ob9nRS+kHQlIwhl2AQU/SLPXigKTiXNDMqYwmmgMbIc=";
  };

  outputs = [
    "bin"
    "dev"
    "out"
    "man"
    "doc"
  ];

  nativeBuildInputs = [ gettext ];

  # tools/attr.c: Add missing libgen.h include for basename(3)
  # Fixes compilation issue with musl and modern C99 compilers.
  # See: https://bugs.gentoo.org/926294
  patches = [ ./musl.patch ];

  postPatch = ''
    for script in install-sh include/install-sh; do
      patchShebangs $script
    done
  '';

  # See nixos/tests/attr.nix
  doCheck = false;

  meta = {
    homepage = "https://savannah.nongnu.org/projects/attr/";
    description = "Library and tools for manipulating extended attributes";
    platforms = lib.platforms.linux;
    badPlatforms = lib.platforms.microblaze;
    license = lib.licenses.gpl2Plus;
    identifiers.cpeParts = lib.meta.cpeFullVersionWithVendor "attr_project" version;
  };
}
