{
  lib,
  stdenv,
  fetchurl,
  gettext,
  attr,
}:

# Note: this package is used for bootstrapping fetchurl, and thus
# cannot use fetchpatch! All mutable patches (generated by GitHub or
# cgit) that are needed here should be included directly in Nixpkgs as
# files.

stdenv.mkDerivation rec {
  pname = "acl";
  version = "2.3.2";

  src = fetchurl {
    url = "mirror://savannah/acl/acl-${version}.tar.gz";
    hash = "sha256-XyvbrWKXB6p9hcYj+ZSqih0t7FWnPeUgW6wL9gWKL3w=";
  };

  outputs = [
    "bin"
    "dev"
    "out"
    "man"
    "doc"
  ];

  nativeBuildInputs = [ gettext ];
  buildInputs = [ attr ];

  postPatch = ''
    patchShebangs .
  '';

  meta = {
    inherit (attr.meta) platforms badPlatforms;
    homepage = "https://savannah.nongnu.org/projects/acl";
    description = "Library and tools for manipulating access control lists";
    license = lib.licenses.gpl2Plus;
    identifiers.cpeParts = lib.meta.cpeFullVersionWithVendor "acl_project" version;
  };
}
