{
  stdenv,
  lib,
  fetchFromGitHub,
  nix-update-script,
  glib,
  meson,
  ninja,
  pkg-config,
  vala,
  wayland-scanner,
  accountsservice,
  elementary-settings-daemon,
  granite,
  gtk3,
  libgee,
  libhandy,
  libportal,
  packagekit,
  wayland,
  wingpanel,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "wingpanel-quick-settings";
  version = "1.4.0";

  src = fetchFromGitHub {
    owner = "elementary";
    repo = "quick-settings";
    rev = finalAttrs.version;
    hash = "sha256-J40h/4xhs12FmaaBpQ+0/KGCtRLmP592TS3xHeoxGIE=";
  };

  patches = [
    # We no longer ship Pantheon X11 session in NixOS.
    # https://github.com/elementary/session-settings/issues/91
    # https://github.com/elementary/session-settings/issues/82
    ./hide-onscreen-keyboard-settings.patch
  ];

  nativeBuildInputs = [
    glib # glib-compile-resources
    meson
    ninja
    pkg-config
    vala
    wayland-scanner
  ];

  buildInputs = [
    accountsservice
    elementary-settings-daemon # for prefers-color-scheme
    glib
    granite
    gtk3
    libgee
    libhandy
    libportal
    packagekit
    wayland
    wingpanel
  ];

  passthru = {
    updateScript = nix-update-script { };
  };

  meta = {
    description = "Quick settings menu for Wingpanel";
    homepage = "https://github.com/elementary/quick-settings";
    license = lib.licenses.gpl3Plus;
    platforms = lib.platforms.linux;
    teams = [ lib.teams.pantheon ];
  };
})
