{
  lib,
  stdenv,
  fetchurl,
  buildPackages,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "yasm";
  version = "1.3.0";

  src = fetchurl {
    url = "https://www.tortall.net/projects/yasm/releases/yasm-${finalAttrs.version}.tar.gz";
    sha256 = "0gv0slmm0qpq91za3v2v9glff3il594x5xsrbgab7xcmnh0ndkix";
  };

  patches = [
    # https://github.com/yasm/yasm/pull/287
    ./gcc-15.patch
  ];

  depsBuildBuild = [ buildPackages.stdenv.cc ];

  meta = {
    homepage = "http://www.tortall.net/projects/yasm/";
    description = "Complete rewrite of the NASM assembler";
    license = lib.licenses.bsd2;
    platforms = lib.platforms.unix;
  };
})
