{
  lib,
  python3Packages,
  fetchFromGitHub,
  nix,
  ronn,
}:

python3Packages.buildPythonApplication (finalAttrs: {
  pname = "vulnix";
  version = "1.12.3";
  format = "setuptools";

  src = fetchFromGitHub {
    owner = "nix-community";
    repo = "vulnix";
    tag = finalAttrs.version;
    hash = "sha256-q6Mktt9tuX4uDk3hNvDT1928tf+Kb6gBIgwy7w2N8nk=";
  };

  __darwinAllowLocalNetworking = true;

  outputs = [
    "out"
    "doc"
    "man"
  ];
  nativeBuildInputs = [ ronn ];

  nativeCheckInputs = with python3Packages; [
    freezegun
    pytestCheckHook
    pytest-cov-stub
  ];

  propagatedBuildInputs = [
    nix
  ]
  ++ (with python3Packages; [
    click
    colorama
    pyyaml
    requests
    setuptools
    toml
    zodb
  ]);

  postBuild = "make -C doc";

  enabledTestPaths = [ "src/vulnix" ];

  postInstall = ''
    install -D -t $doc/share/doc/vulnix README.rst CHANGES.rst
    gzip $doc/share/doc/vulnix/*.rst
    install -D -t $man/share/man/man1 doc/vulnix.1
    install -D -t $man/share/man/man5 doc/vulnix-whitelist.5
  '';

  dontStrip = true;

  meta = {
    description = "NixOS vulnerability scanner";
    mainProgram = "vulnix";
    homepage = "https://github.com/nix-community/vulnix";
    license = lib.licenses.bsd3;
    maintainers = with lib.maintainers; [ henrirosten ];
  };
})
