{
  lib,
  stdenv,
  argp-standalone,
  fetchFromGitLab,
  autoreconfHook,
  libarchive,
  pkg-config,
  versionCheckHook,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "unrar-free";
  version = "0.3.3";

  src = fetchFromGitLab {
    owner = "bgermann";
    repo = "unrar-free";
    tag = finalAttrs.version;
    hash = "sha256-3eI8vWc6E+gj+LwBG6jG1l8h8EXXcAQ44W0ALzwOOFg=";
  };

  nativeBuildInputs = [
    autoreconfHook
    pkg-config
  ];

  buildInputs = [
    libarchive
  ]
  ++ lib.optionals stdenv.hostPlatform.isDarwin [
    argp-standalone
  ];

  env.NIX_LDFLAGS = lib.optionalString stdenv.hostPlatform.isDarwin "-largp";

  setupHook = ./setup-hook.sh;

  nativeInstallCheckInputs = [ versionCheckHook ];
  doInstallCheck = true;

  meta = {
    description = "Free utility to extract files from RAR archives";
    longDescription = ''
      unrar-free is a free software version of the non-free unrar utility.

      This program is a simple command-line front-end to libarchive, and can list
      and extract RAR archives but also other formats supported by libarchive.

      It does not rival the non-free unrar in terms of features, but
      special care has been taken to ensure it meets most user's needs.
    '';
    homepage = "https://gitlab.com/bgermann/unrar-free";
    license = lib.licenses.gpl2Plus;
    mainProgram = "unrar-free";
    maintainers = with lib.maintainers; [
      anthonyroussel
      thiagokokada
    ];
    platforms = lib.platforms.unix;
  };
})
