{
  lib,
  stdenv,
  fetchFromGitHub,
  openssl,
  perl,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "tmux-xpanes";
  version = "4.2.0";

  src = fetchFromGitHub {
    owner = "greymd";
    repo = "tmux-xpanes";
    rev = "v${finalAttrs.version}";
    sha256 = "sha256-PF2K2A49c5djQqSO7ZLFyBwPZaJRK58qZTFpY7n+Z0w=";
  };

  buildInputs = [
    openssl
    perl
  ];

  installPhase = ''
    # Create directories.
    install -m 755 -d $out/bin/
    install -m 755 -d $out/share/man/man1/

    # Perform installation.
    install -m 755 bin/* $out/bin/
    install -m 644 man/*.1 $out/share/man/man1/
  '';

  meta = {
    description = "tmux-based terminal divider";
    homepage = "https://github.com/greymd/tmux-xpanes";
    license = lib.licenses.mit;
    platforms = lib.platforms.unix;
    maintainers = with lib.maintainers; [ monsieurp ];
  };
})
