{
  lib,
  fetchurl,
  makeWrapper,
  nextflow,
  nf-test,
  openjdk17,
  stdenv,
  testers,
}:
stdenv.mkDerivation (finalAttrs: {

  pname = "nf-test";
  version = "0.9.4";

  src = fetchurl {
    url = "https://github.com/askimed/nf-test/releases/download/v${finalAttrs.version}/nf-test-${finalAttrs.version}.tar.gz";
    hash = "sha256-A9k8HVIPqbfHZKqSY2wqOhgvZ9aSb3K4SdoLOypB2j8=";
  };
  sourceRoot = ".";

  nativeBuildInputs = [ makeWrapper ];

  installPhase = ''
    runHook preInstall

    mkdir -p $out/share/nf-test
    install -Dm644 nf-test.jar $out/share/nf-test

    mkdir -p $out/bin
    makeWrapper ${openjdk17}/bin/java $out/bin/nf-test \
      --add-flags "-jar $out/share/nf-test/nf-test.jar" \
      --prefix PATH : ${lib.makeBinPath [ nextflow ]} \

    runHook postInstall
  '';

  passthru.tests.version = testers.testVersion {
    package = nf-test;
    command = "nf-test version";
  };

  meta = {
    description = "Simple test framework for Nextflow pipelines";
    homepage = "https://www.nf-test.com/";
    changelog = "https://github.com/askimed/nf-test/releases";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ rollf ];
    mainProgram = "nf-test";
    platforms = lib.platforms.unix;
  };
})
