{
  lib,
  stdenv,
  fetchurl,
  bison,
  flex,
  gccmakedep,
  imake,
  libxau,
  libxaw,
  libxext,
  libxpm,
  libxt,
  xorg-cf-files,
  xorgproto,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "nas";
  version = "1.9.5";

  src = fetchurl {
    url = "mirror://sourceforge/nas/nas-${finalAttrs.version}.tar.gz";
    hash = "sha256-t4hK+zj+7AOhlr07fpxHuAPIMOzRDXRV6cl+Eiw3lEw=";
  };

  nativeBuildInputs = [
    bison
    flex
    gccmakedep
    imake
  ];

  buildInputs = [
    libxau
    libxaw
    libxext
    libxpm
    libxt
    xorgproto
  ];

  buildFlags = [
    "WORLDOPTS="
    "World"
  ];

  env.NIX_CFLAGS_COMPILE = toString [
    "-std=c17"
    "-Wno-error=implicit-function-declaration"
    "-Wno-error=implicit-int"
    "-Wno-error=incompatible-pointer-types"
  ];

  installFlags = [
    "LDLIBS=-lfl"
    "DESTDIR=${placeholder "out"}"
  ];

  postInstall = ''
    mv $out/${xorg-cf-files}/* $out
    rm -fr $out/nix
  '';

  meta = {
    homepage = "http://radscan.com/nas.html";
    description = "Network transparent, client/server audio transport system";
    license = lib.licenses.mit;
    maintainers = [ ];
    platforms = lib.platforms.linux;
  };
})
