{
  lib,
  fetchFromGitLab,
  python3Packages,
  sphinxHook,
  nix-update-script,
}:

python3Packages.buildPythonApplication (finalAttrs: {
  pname = "mpd-sima";
  version = "0.18.2";

  src = fetchFromGitLab {
    owner = "kaliko";
    repo = "sima";
    rev = finalAttrs.version;
    hash = "sha256-lMvM1EqS1govhv4B2hJzIg5DFQYgEr4yJJtgOQxnVlY=";
  };

  format = "setuptools";

  postPatch = ''
    sed -i '/intersphinx/d' doc/source/conf.py
  '';

  nativeBuildInputs = [
    sphinxHook
  ];

  sphinxBuilders = [ "man" ];

  dependencies = with python3Packages; [
    requests
    python-musicpd
  ];

  doCheck = true;

  preCheck = ''
    export HOME="$(mktemp -d)"
  '';

  passthru.updateScript = nix-update-script { };

  meta = {
    description = "Autoqueuing mpd client";
    homepage = "https://kaliko.me/mpd-sima/";
    license = lib.licenses.gpl3Plus;
    platforms = lib.platforms.linux;
    maintainers = with lib.maintainers; [ apfelkuchen6 ];
    mainProgram = "mpd-sima";
  };
})
