{
  lib,
  stdenv,
  fetchurl,
  fetchpatch,
  openssl,
  ncurses,
  pkg-config,
  glib,
  loudmouth,
  libotr,
  gpgme,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "mcabber";
  version = "1.1.2";

  src = fetchurl {
    url = "https://mcabber.com/files/mcabber-${finalAttrs.version}.tar.bz2";
    sha256 = "0q1i5acyghsmzas88qswvki8kkk2nfpr8zapgnxbcd3lwcxl38f4";
  };

  patches = [
    # Pull upstream patch for ncurses-6.3.
    (fetchpatch {
      name = "ncurses-6.3.patch";
      url = "https://github.com/McKael/mcabber/commit/5a0893d69023b77b7671731defbdca5d47731130.patch";
      sha256 = "01bc23z0mva9l9jv587sq2r9w3diachgkmb9ad99hlzgj02fmq4v";
      stripLen = 1;
    })
    ./add-missing-arguments-to-function-prototypes.patch
  ];

  nativeBuildInputs = [ pkg-config ];
  buildInputs = [
    openssl
    ncurses
    glib
    loudmouth
    libotr
    gpgme
  ];

  configureFlags = [
    "--with-openssl=${openssl.dev}"
    "--enable-modules"
    "--enable-otr"
  ];

  doCheck = true;

  meta = {
    homepage = "http://mcabber.com/";
    description = "Small Jabber console client";
    mainProgram = "mcabber";
    license = lib.licenses.gpl2;
    maintainers = with lib.maintainers; [ pSub ];
    platforms = with lib.platforms; linux;
    downloadPage = "http://mcabber.com/files/";
  };
})
