{
  lib,
  stdenv,
  fetchFromGitHub,
  meson,
  ninja,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "lyra";
  version = "1.7.0";

  src = fetchFromGitHub {
    owner = "bfgroup";
    repo = "lyra";
    rev = finalAttrs.version;
    sha256 = "sha256-X8wJwSfOo7v2SKYrKJ4RhpEmOdEkS8lPHIqCxP46VF4=";
  };

  nativeBuildInputs = [
    meson
    ninja
  ];

  postPatch = "sed -i s#/usr#$out#g meson.build";

  postInstall = ''
    mkdir -p $out/include
    cp -R $src/include/* $out/include
  '';

  meta = {
    homepage = "https://github.com/bfgroup/Lyra";
    description = "Simple to use, composable, command line parser for C++ 11 and beyond";
    platforms = lib.platforms.unix;
    license = lib.licenses.boost;
    maintainers = [ ];
  };
})
