{
  lib,
  fetchFromGitHub,
  python3Packages,
  fetchpatch,
}:

python3Packages.buildPythonApplication (finalAttrs: {
  pname = "hovercraft";
  version = "2.7";
  pyproject = true;
  disabled = !python3Packages.isPy3k;

  src = fetchFromGitHub {
    owner = "regebro";
    repo = "hovercraft";
    tag = finalAttrs.version;
    hash = "sha256-X6EaiVahAYAaFB65oqmj695wlJFXNseqz0SQLzGVD0w=";
  };

  build-system = [ python3Packages.setuptools ];

  nativeCheckInputs = [ python3Packages.manuel ];

  dependencies = with python3Packages; [
    setuptools
    docutils
    lxml
    svg-path
    pygments
    watchdog
  ];
  patches = [
    (fetchpatch {
      name = "fix tests with pygments 2.14";
      url = "https://sources.debian.org/data/main/h/hovercraft/2.7-5/debian/patches/0003-Fix-tests-with-pygments-2.14.patch";
      hash = "sha256-qz4Kp4MxlS3KPKRB5/VESCI++66U9q6cjQ0cHy3QjTc=";
    })
  ];

  meta = {
    description = "Makes impress.js presentations from reStructuredText";
    mainProgram = "hovercraft";
    homepage = "https://github.com/regebro/hovercraft";
    license = lib.licenses.mit;
    maintainers = [ lib.maintainers.makefu ];
  };
})
