{
  lib,
  buildGoModule,
  fetchFromGitHub,
}:

buildGoModule (finalAttrs: {
  pname = "go-exploitdb";
  version = "0.7.0";

  src = fetchFromGitHub {
    owner = "vulsio";
    repo = "go-exploitdb";
    tag = "v${finalAttrs.version}";
    hash = "sha256-sPBFFhQ9z5ecJMnys9U7QDaBVSEKm9V8jka19d1Eafg=";
  };

  vendorHash = "sha256-qWo2PfrvO/eWIf7DjTmbi0qETOg/6jrHZ3BdfugLyGc=";

  ldflags = [
    "-s"
    "-w"
    "-X=github.com/vulsio/go-exploitdb/config.Version=${finalAttrs.version}"
  ];

  meta = {
    description = "Tool for searching Exploits from Exploit Databases, etc";
    mainProgram = "go-exploitdb";
    homepage = "https://github.com/vulsio/go-exploitdb";
    changelog = "https://github.com/vulsio/go-exploitdb/releases/tag/${finalAttrs.src.tag}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ fab ];
  };
})
