{
  lib,
  stdenv,
  fetchurl,
  fltk_1_3,
  libjpeg,
  pkg-config,
}:

stdenv.mkDerivation (finalAttrs: {
  version = "1.3.6";
  pname = "flwrap";

  src = fetchurl {
    url = "mirror://sourceforge/fldigi/flwrap-${finalAttrs.version}.tar.gz";
    sha256 = "sha256-g1V7bOcgVHpD+Ndn02Nj4I3rGItuQ2qLGlrZZshfGP8=";
  };

  nativeBuildInputs = [
    pkg-config
  ];

  buildInputs = [
    fltk_1_3
    libjpeg
  ];

  configureFlags = [
    "FLTK_CONFIG=${lib.getExe' (lib.getDev fltk_1_3) "fltk-config"}"
  ];

  meta = {
    description = "Digital modem file transfer program";
    homepage = "https://sourceforge.net/projects/fldigi/";
    license = lib.licenses.gpl3Plus;
    maintainers = with lib.maintainers; [ dysinger ];
    platforms = lib.platforms.linux;
    mainProgram = "flwrap";
  };
})
