# generated by zon2nix (https://github.com/Cloudef/zig2nix)

{
  lib,
  linkFarm,
  fetchurl,
  fetchgit,
  runCommandLocal,
  zig,
  name ? "zig-packages",
}:

let
  unpackZigArtifact =
    { name, artifact }:
    runCommandLocal name { nativeBuildInputs = [ zig ]; } ''
      hash="$(zig fetch --global-cache-dir "$TMPDIR" ${artifact})"
      mv "$TMPDIR/p/$hash" "$out"
      chmod 755 "$out"
    '';

  fetchZig =
    {
      name,
      url,
      hash,
    }:
    let
      artifact = fetchurl { inherit url hash; };
    in
    unpackZigArtifact { inherit name artifact; };

  fetchGitZig =
    {
      name,
      url,
      hash,
      rev ? throw "rev is required, remove and regenerate the zon2json-lock file",
    }:
    let
      parts = lib.splitString "#" url;
      url_base = lib.elemAt parts 0;
      url_without_query = lib.elemAt (lib.splitString "?" url_base) 0;
    in
    fetchgit {
      inherit name rev hash;
      url = url_without_query;
      deepClone = false;
    };

  fetchZigArtifact =
    {
      name,
      url,
      hash,
      ...
    }@args:
    let
      parts = lib.splitString "://" url;
      proto = lib.elemAt parts 0;
      path = lib.elemAt parts 1;
      fetcher = {
        "git+http" = fetchGitZig (
          args
          // {
            url = "http://${path}";
          }
        );
        "git+https" = fetchGitZig (
          args
          // {
            url = "https://${path}";
          }
        );
        http = fetchZig {
          inherit name hash;
          url = "http://${path}";
        };
        https = fetchZig {
          inherit name hash;
          url = "https://${path}";
        };
      };
    in
    fetcher.${proto};
in
linkFarm name [
  {
    name = "flow_syntax-0.1.0-X8jOoU8VAQCOYNTiuB7y2aIBP1V3OXXHa8WvE3eXtpDK";
    path = fetchZigArtifact {
      name = "syntax";
      url = "git+https://github.com/neurocyte/flow-syntax?ref=master#10b92330cf0ecaa39a52d3a8d190f7fb384b7b09";
      hash = "sha256-w6h8KN6oNS5PPTgOfMlCz3aRH6o2CY2Fl/LnUd1PVq8=";
      rev = "10b92330cf0ecaa39a52d3a8d190f7fb384b7b09";
    };
  }
  {
    name = "tree_sitter-0.22.4-150-g7e3f5726-z0LhyI7XuS7mSbx26jCz5VkJ_c1oL8vvC6WBgx0Idkpg";
    path = fetchZigArtifact {
      name = "tree_sitter";
      url = "https://github.com/neurocyte/tree-sitter/releases/download/master-3cfb01c2f3349791a500f59bcc89b867d017d5b8/source.tar.gz";
      hash = "sha256-2vIwHvTyXAjLT6qC1zrtCM1OjSJAta4z/2MkctSbl2g=";
    };
  }
  {
    name = "cbor-1.0.0-RcQE_AswAQAPlqBCZXYQf9DZXn-0Ubt8Mk03ZcJWcsAG";
    path = fetchZigArtifact {
      name = "cbor";
      url = "git+https://github.com/neurocyte/cbor?ref=master#7d2eeb68c8a2fb3f4d6baad6cc04c521b92974c0";
      hash = "sha256-EWOz+BPxRB5NxmqNzrJcdcaoGH6PdgeU4KI9IjJqar8=";
      rev = "7d2eeb68c8a2fb3f4d6baad6cc04c521b92974c0";
    };
  }
  {
    name = "flags-0.10.0-a_9h3gB4AADAYn0XaZuUqH1jKRmy6dqvAIbomtTIF6V1";
    path = fetchZigArtifact {
      name = "flags";
      url = "git+https://github.com/neurocyte/flags?ref=main#984b27948da3e4e40a253f76c85b51ec1a9ada11";
      hash = "sha256-PnR8RI1Rp1FxtjzBYcLCWi6zXykSsHVYnNkmI2XVxh4=";
      rev = "984b27948da3e4e40a253f76c85b51ec1a9ada11";
    };
  }
  {
    name = "dizzy-1.0.0-q40X4YCRAAAGYO9QOZiYYSOwiiFlqZlecMuQcxPiBcXM";
    path = fetchZigArtifact {
      name = "dizzy";
      url = "https://github.com/neurocyte/dizzy/archive/c9219d23daccd9aa226cfde754fea278cb516459.tar.gz";
      hash = "sha256-lFtDVVlIYt/5lCCTTOEfEFd8w1osV8JSvreMmK3YtIc=";
    };
  }
  {
    name = "libfuzzer_kit-0.0.0-i7XWVl2PBwC3r18KoW8xTU05KyWEMj6RfBpAXd3CQqt7";
    path = fetchZigArtifact {
      name = "libfuzzer_kit";
      url = "git+https://github.com/SuperAuguste/zig-libfuzzer-kit.git#a27221dda33b232e65504766294ea4c7c079c3f0";
      hash = "sha256-yxhiP2kJYli5VjF0uMJcDM0ByFIRmSxnwnMy0JwQxmU=";
      rev = "a27221dda33b232e65504766294ea4c7c079c3f0";
    };
  }
  {
    name = "thespian-0.0.1-owFOjjMiBgCXFa9f0-RKTDgWwYzQp1Mnec_p6hsGXj_G";
    path = fetchZigArtifact {
      name = "thespian";
      url = "git+https://github.com/neurocyte/thespian?ref=master#6eadc0fe29795f88752f3b6f296dc582b16cb5a1";
      hash = "sha256-+Jlg6ai/C0/0/Ou4b/SErtQR8AkEylG0kNwA+qw9bDU=";
      rev = "6eadc0fe29795f88752f3b6f296dc582b16cb5a1";
    };
  }
  {
    name = "asio-1.30.2-tLhDd0SB4QB1041_DEW_1cvEw8eMfBYLAwjN_G53Fn66";
    path = fetchZigArtifact {
      name = "asio";
      url = "git+https://github.com/neurocyte/asio#0f1cbf24e5fb6fabe7078a20b76452f42e24a0df";
      hash = "sha256-H3y7CTAlEpl0y3ERrNht8KabDRqvNDE+MzK4Uud2wAQ=";
      rev = "0f1cbf24e5fb6fabe7078a20b76452f42e24a0df";
    };
  }
  {
    name = "zig_tracy-0.0.3-5-cp3Ht3AAAfHqShKfTK7waFK3Wjd3l2NheiqxvRRAdo";
    path = fetchZigArtifact {
      name = "tracy";
      url = "git+https://github.com/neurocyte/zig-tracy#67070c146104d93fd3bed5091738f22e33e13bce";
      hash = "sha256-YcSgPAQo/4+mrKkJS5UAn7z5xZjeb8kKIWrBK3yXhQ4=";
      rev = "67070c146104d93fd3bed5091738f22e33e13bce";
    };
  }
  {
    name = "N-V-__8AAO2QjgFRswZWFwtGKFgOVx2Ysf5F18DVgbwtReiU";
    path = fetchZigArtifact {
      name = "tracy_src";
      url = "https://github.com/neurocyte/tracy/archive/0ff0a1b324f497cf313a445637b7df25aabefb47.tar.gz";
      hash = "sha256-dzMilJsOSdjNyvhyDb1v5dPWcR5uvhnQmsBynAJH74I=";
    };
  }
  {
    name = "N-V-__8AAKhUIwB6OywBocsytyvp6XiVu4fZwzFJHjumxGLY";
    path = fetchZigArtifact {
      name = "themes";
      url = "https://github.com/neurocyte/flow-themes/releases/download/master-638f6f95c391420f0f140599ed5f87cc37834559/flow-themes.tar.gz";
      hash = "sha256-CnG0htnCQBoyMGXGguyRUonbseBAgSKwWTm3pH6CXks=";
    };
  }
  {
    name = "fuzzig-0.1.1-Ji0xivxIAQBD0g8O_NV_0foqoPf3elsg9Sc3pNfdVH4D";
    path = fetchZigArtifact {
      name = "fuzzig";
      url = "https://github.com/fjebaker/fuzzig/archive/4251fe4230d38e721514394a485db62ee1667ff3.tar.gz";
      hash = "sha256-VBkKxu+JdPzYRvANLX4/o3Mgl3Ojt1so99D8VNrSbTA=";
    };
  }
  {
    name = "vaxis-0.5.1-BWNV_PIfCQBrMQyEAPPSOyupQYEud7vTs0jXEq5drkC9";
    path = fetchZigArtifact {
      name = "vaxis";
      url = "git+https://github.com/neurocyte/libvaxis?ref=main#4debeaf0774a6db5de8bab212335fae795086035";
      hash = "sha256-bfcOR5vzytKHbQHR6z71G+GE+iuEUuM23+38y6V+6Ss=";
      rev = "4debeaf0774a6db5de8bab212335fae795086035";
    };
  }
  {
    name = "zigimg-0.1.0-8_eo2vHnEwCIVW34Q14Ec-xUlzIoVg86-7FU2ypPtxms";
    path = fetchZigArtifact {
      name = "zigimg";
      url = "https://github.com/ivanstepanovftw/zigimg/archive/d7b7ab0ba0899643831ef042bd73289510b39906.tar.gz";
      hash = "sha256-LB7Xa6KzVRRUSwwnyWM+y6fDG+kIDjfnoBDJO1obxVM=";
    };
  }
  {
    name = "zg-0.15.2-oGqU3AtAtAI7gs7zPvzg2_TlVIqi9wCNEw7DLvD5OvDN";
    path = fetchZigArtifact {
      name = "zg";
      url = "git+https://codeberg.org/neurocyte/zg?ref=master#cdcab8b9ea3458efd710008055d993c5dbdb1af7";
      hash = "sha256-dCaDTiZX62SZfJHMZn2IfwADbRegpNIM7u/dBPZ580k=";
      rev = "cdcab8b9ea3458efd710008055d993c5dbdb1af7";
    };
  }
  {
    name = "zeit-0.6.0-5I6bk0J9AgCVa0nnyL0lNY9Xa9F68hHq-ZarhuXNV-Jb";
    path = fetchZigArtifact {
      name = "zeit";
      url = "git+https://github.com/rockorager/zeit?ref=zig-0.15#ed2ca60db118414bda2b12df2039e33bad3b0b88";
      hash = "sha256-IvXaqAzaWi3E1XBqQltCBFoRmXehZkVol3/RZwOsAKg=";
      rev = "ed2ca60db118414bda2b12df2039e33bad3b0b88";
    };
  }
  {
    name = "zigwin32-25.0.28-preview-AAAAAICM5AMResOGQnQ85mfe60TTOQeMtt7GRATUOKoP";
    path = fetchZigArtifact {
      name = "win32";
      url = "git+https://github.com/marlersoft/zigwin32?ref=main#5587b16fa040573846a6bf531301f6206d31a6bf";
      hash = "sha256-GIH6aO8yEWKKvIr4syG6aYViXi2whIg4feWox7f9ZSM=";
      rev = "5587b16fa040573846a6bf531301f6206d31a6bf";
    };
  }
]
