{
  cmake,
  extra-cmake-modules,
  fancontrol-gui,
  fetchFromGitHub,
  lib,
  libgcc,
  libsForQt5,
  nix-update-script,
  stdenv,
  testers,
}:
stdenv.mkDerivation (finalAttrs: {
  pname = "fancontrol-gui";
  version = "0.8";

  src = fetchFromGitHub {
    owner = "Maldela";
    repo = "fancontrol-gui";
    tag = "v${finalAttrs.version}";
    hash = "sha256-hJaU8SL0b6GmTONGSIzUzzbex6KxHf2Np0bCX8YSSVM=";
  };

  buildInputs = with libsForQt5; [
    libgcc
    kcmutils
    kdeclarative
    kio
    plasma-framework
    qt5.qtdeclarative
    qt5.qtquickcontrols
    qt5.qtquickcontrols2
  ];

  nativeBuildInputs = [
    cmake
    extra-cmake-modules
    libsForQt5.wrapQtAppsHook
  ];

  patches = [
    ./version.patch
  ];

  postPatch = ''
    substituteInPlace CMakeLists.txt \
      --replace-fail "cmake_minimum_required(VERSION 3.0.2)" "cmake_minimum_required(VERSION 3.10)"
  '';

  passthru = {
    tests.version = testers.testVersion {
      package = fancontrol-gui;
      command = "env QT_QPA_PLATFORM=minimal ${lib.getExe fancontrol-gui} --version";
    };
    updateScript = nix-update-script { };
  };

  meta = {
    description = "GUI for fancontrol with QT and KDE framework 5";
    homepage = "https://github.com/Maldela/fancontrol-gui";
    changelog = "https://github.com/Maldela/fancontrol-gui/releases/tag/v${finalAttrs.version}";
    license = lib.licenses.gpl2Plus;
    mainProgram = "fancontrol_gui";
    maintainers = with lib.maintainers; [ dashietm ];
    platforms = lib.platforms.linux;
  };
})
