{
  lib,
  buildGoModule,
  fetchFromGitHub,
}:

buildGoModule (finalAttrs: {
  pname = "ctop";
  version = "0.7.7";

  src = fetchFromGitHub {
    owner = "bcicen";
    repo = "ctop";
    rev = "v${finalAttrs.version}";
    sha256 = "sha256-tojSzgpoGQg6MwV/MVpQpCA5w6bZO+9IOvfkw0Ydr6c=";
  };

  vendorHash = "sha256-UAja7XuoLqJFNcK1PgHGcuf/HbvSrWyRvW2D3T7Hg0g=";

  ldflags = [
    "-s"
    "-w"
    "-X main.version=${finalAttrs.version}"
    "-X main.build=v${finalAttrs.version}"
  ];

  meta = {
    description = "Top-like interface for container metrics";
    homepage = "https://ctop.sh/";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ apeyroux ];
    mainProgram = "ctop";
  };
})
