{
  buildGoModule,
  fetchFromGitHub,
  testers,
  lib,
  csvq,
}:

buildGoModule (finalAttrs: {
  pname = "csvq";
  version = "1.18.1";

  src = fetchFromGitHub {
    owner = "mithrandie";
    repo = "csvq";
    rev = "v${finalAttrs.version}";
    hash = "sha256-1UK+LSMKryoUf2UWbGt8MU3zs5hH2WdpA2v/jBaIHYE=";
  };

  vendorHash = "sha256-byBYp+iNnnsAXR+T3XmdwaeeBG8oB1EgNkDabzgUC98=";

  passthru.tests.version = testers.testVersion {
    package = csvq;
    version = "csvq version ${finalAttrs.version}";
  };

  meta = {
    description = "SQL-like query language for CSV";
    mainProgram = "csvq";
    homepage = "https://mithrandie.github.io/csvq/";
    changelog = "https://github.com/mithrandie/csvq/releases/tag/v${finalAttrs.version}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ tomodachi94 ];
  };
})
