{
  lib,
  stdenv,
  fetchurl,
  blas,
  gfortran,
  lapack,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "csdp";
  version = "6.1.1";

  src = fetchurl {
    url = "https://www.coin-or.org/download/source/Csdp/Csdp-${finalAttrs.version}.tgz";
    sha256 = "1f9ql6cjy2gwiyc51ylfan24v1ca9sjajxkbhszlds1lqmma8n05";
  };

  buildInputs = [
    blas
    gfortran.cc.lib
    lapack
  ];

  postPatch = ''
    substituteInPlace Makefile --replace /usr/local/bin $out/bin
    substituteInPlace lib/Makefile \
      --replace-fail 'ar cr' '${stdenv.cc.targetPrefix}ar cr'
  '';

  preInstall = ''
    rm -f INSTALL
    mkdir -p $out/bin
  '';

  meta = {
    homepage = "https://projects.coin-or.org/Csdp";
    license = lib.licenses.cpl10;
    maintainers = [ lib.maintainers.roconnor ];
    description = "C Library for Semidefinite Programming";
    platforms = lib.platforms.unix;
  };
})
