{
  lib,
  stdenv,
  fetchurl,
  which,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "cntlm";
  version = "0.92.3";

  src = fetchurl {
    url = "mirror://sourceforge/cntlm/cntlm-${finalAttrs.version}.tar.gz";
    sha256 = "1632szz849wasvh5sm6rm1zbvbrkq35k7kcyvx474gyl4h4x2flw";
  };

  buildInputs = [ which ];

  preConfigure = lib.optionalString stdenv.hostPlatform.isDarwin ''
    substituteInPlace configure --replace "xlc_r gcc" "xlc_r gcc $CC"
    substitute Makefile Makefile.$CC --replace "CC=gcc" "CC=$CC"
  '';

  installPhase = ''
    mkdir -p $out/bin; cp cntlm $out/bin/;
    mkdir -p $out/share/; cp COPYRIGHT README VERSION doc/cntlm.conf $out/share/;
    mkdir -p $out/man/; cp doc/cntlm.1 $out/man/;
  '';

  meta = {
    description = "NTLM/NTLMv2 authenticating HTTP proxy";
    homepage = "https://cntlm.sourceforge.net/";
    license = lib.licenses.gpl2Only;
    maintainers = [
      lib.maintainers.qknight
      lib.maintainers.carlosdagos
    ];
    platforms = lib.platforms.linux ++ lib.platforms.darwin;
    mainProgram = "cntlm";
  };
})
