{
  lib,
  python3Packages,
  fetchFromGitHub,

  # dependencies
  cmake-format,

  # tests
  cmake,
  versionCheckHook,
}:

let
  pythonPackages = python3Packages.overrideScope (
    self: super: {
      lsprotocol = self.lsprotocol_2023;
      pygls = self.pygls_1;
    }
  );
in
pythonPackages.buildPythonApplication (finalAttrs: {
  pname = "cmake-language-server";
  version = "0.1.11";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "regen100";
    repo = "cmake-language-server";
    tag = "v${finalAttrs.version}";
    hash = "sha256-QxknG5NFYky6ZSjiIugLfHT4gXsyTBVbMMeULhQsmdk=";
  };

  # Test timeouts occasionally cause the build to fail
  postPatch = ''
    substituteInPlace tests/test_server.py \
      --replace-fail \
        "CALL_TIMEOUT = 2" \
        "CALL_TIMEOUT = 10"
  '';

  build-system = with pythonPackages; [
    pdm-backend
  ];
  dontUseCmakeConfigure = true;

  dependencies = with pythonPackages; [
    pygls
  ];

  pythonImportsCheck = [ "cmake_language_server" ];

  nativeCheckInputs = [
    cmake
    cmake-format
    versionCheckHook
  ]
  ++ (with pythonPackages; [
    pytest-datadir
    pytestCheckHook
  ]);

  # version.py generated by pdm, no idea why it's not present in test phase
  # https://github.com/regen100/cmake-language-server/blob/v0.1.11/pyproject.toml#L35-L36
  preCheck = ''
    echo "__version__ = \"$PDM_BUILD_SCM_VERSION\"" > cmake_language_server/version.py
  '';

  disabledTests = [
    # AssertionError: CTEST_SCP_COMMAND not found
    "test_parse_variables"

    # AssertionError: AddFileDependencies not found
    "test_parse_modules"

    # AssertionError: assert 'Boost' in [...
    "test_completions_triggercharacter"
  ];

  meta = {
    description = "CMake LSP Implementation";
    homepage = "https://github.com/regen100/cmake-language-server";
    changelog = "https://github.com/regen100/cmake-language-server/releases/tag/${finalAttrs.src.tag}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ kira-bruneau ];
    mainProgram = "cmake-language-server";
  };
})
