{
  lib,
  stdenv,
  fetchFromGitHub,
  makeWrapper,
  mariadb,
  mailutils,
  pbzip2,
  pigz,
  bzip2,
  gzip,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "automysqlbackup";
  version = "3.0.7";

  src = fetchFromGitHub {
    owner = "sixhop";
    repo = "automysqlbackup";
    tag = finalAttrs.version;
    sha256 = "sha256-C0p1AY4yIxybQ6a/HsE3ZTHumtvQw5kKM51Ap+Se0ZI=";
  };

  nativeBuildInputs = [ makeWrapper ];

  installPhase = ''
    mkdir -p $out/bin $out/etc

    cp automysqlbackup $out/bin/
    cp automysqlbackup.conf $out/etc/

    wrapProgram $out/bin/automysqlbackup --prefix PATH : ${
      lib.makeBinPath [
        mariadb
        mailutils
        pbzip2
        pigz
        bzip2
        gzip
      ]
    }
  '';

  meta = {
    description = "Script to run daily, weekly and monthly backups for your MySQL database";
    mainProgram = "automysqlbackup";
    homepage = "https://github.com/sixhop/AutoMySQLBackup";
    platforms = lib.platforms.linux;
    maintainers = [ lib.maintainers.aanderse ];
    license = lib.licenses.gpl2Plus;
  };
})
