{
  lib,
  python3,
  python3Packages,
  fetchFromGitHub,
}:
python3Packages.buildPythonApplication (finalAttrs: {
  pname = "arxiv-latex-cleaner";
  version = "1.0.8";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "google-research";
    repo = "arxiv-latex-cleaner";
    tag = "v${finalAttrs.version}";
    hash = "sha256-CQb1u1j+/px+vNqA3iXZ2oe6/0ZWeMjWrUQL9elRDEI=";
  };

  build-system = with python3Packages; [
    setuptools
  ];

  dependencies = with python3Packages; [
    pillow
    pyyaml
    regex
    absl-py
  ];

  checkPhase = ''
    runHook preCheck
    ${python3.interpreter} -m unittest arxiv_latex_cleaner.tests.arxiv_latex_cleaner_test
    runHook postCheck
  '';

  meta = {
    homepage = "https://github.com/google-research/arxiv-latex-cleaner";
    description = "Easily clean the LaTeX code of your paper to submit to arXiv";
    mainProgram = "arxiv_latex_cleaner";
    license = lib.licenses.asl20;
    maintainers = with lib.maintainers; [ arkivm ];
  };
})
