{
  lib,
  python3,
  fetchPypi,
}:

python3.pkgs.buildPythonApplication (finalAttrs: {
  pname = "alerta-server";
  version = "9.0.1";
  format = "setuptools";

  src = fetchPypi {
    inherit (finalAttrs) pname version;
    hash = "sha256-v4+0l5Sx9RTxmNFnKCoKrWFl1xu1JIRZ/kiI6zi/y0I=";
  };

  propagatedBuildInputs = with python3.pkgs; [
    bcrypt
    blinker
    cryptography
    flask
    flask-compress
    flask-cors
    mohawk
    psycopg2
    pyjwt
    pymongo
    pyparsing
    python-dateutil
    pytz
    pyyaml
    requests
    requests-hawk
    sentry-sdk
    setuptools
  ];

  # We can't run the tests from Nix, because they rely on the presence of a working MongoDB server
  doCheck = false;

  pythonImportsCheck = [
    "alerta"
  ];

  meta = {
    homepage = "https://alerta.io";
    description = "Alerta Monitoring System server";
    mainProgram = "alertad";
    license = lib.licenses.asl20;
    maintainers = [ ];
  };
})
