{
  lib,
  stdenv,
  dub,
  importDubLock,
  dubSetupHook,
  dubBuildHook,
  dubCheckHook,
  ldc,
  removeReferencesTo,
}:

lib.extendMkDerivation {
  constructDrv = stdenv.mkDerivation;

  excludeDrvArgNames = [
    "dubLock"
    "compiler"
  ];

  extendDrvArgs =
    finalAttrs:
    {
      # A lockfile generated by `dub-to-nix` from the source of the package.
      # Can be either a path to the file, or an attrset already parsed with `lib.importJSON`.
      dubLock,
      compiler ? ldc,
      ...
    }@args:

    {
      dubDeps = importDubLock {
        inherit (finalAttrs) pname version;
        lock = dubLock;
      };

      strictDeps = args.strictDeps or true;

      nativeBuildInputs = args.nativeBuildInputs or [ ] ++ [
        dubSetupHook
        (dubBuildHook.override { inherit dub; })
        compiler
        removeReferencesTo
      ];

      configurePhase = ''
        runHook preConfigure
        dubFlags+=("--compiler=${lib.getExe compiler}")
        runHook postConfigure
      '';

      doCheck = args.doCheck or false;

      nativeCheckInputs = [
        (dubCheckHook.override { inherit dub; })
      ];

      preFixup = ''
        ${args.preFixup or ""}

        find "$out" -type f -exec remove-references-to -t ${compiler} '{}' +
      '';

      disallowedReferences = args.disallowedReferences or [ compiler ];

      meta = {
        platforms = dub.meta.platforms;
      }
      // args.meta or { };
    };
}
