{
  lib,
  rustPlatform,
  fetchFromGitHub,
}:

rustPlatform.buildRustPackage {
  pname = "i3-auto-layout";
  version = "unstable-2022-05-29";

  src = fetchFromGitHub {
    owner = "chmln";
    repo = "i3-auto-layout";
    rev = "9e41eb3891991c35b7d35c9558e788899519a983";
    sha256 = "sha256-gpVYVyh+2y4Tttvw1SuCf7mx/nxR330Ob2R4UmHZSJs=";
  };

  cargoHash = "sha256-oKpcYhD9QNW+8gFVybDEnz58cZ+2Bf4bwYuflXiJ1jc=";

  # Currently no tests are implemented, so we avoid building the package twice
  doCheck = false;

  meta = {
    description = "Automatic, optimal tiling for i3wm";
    mainProgram = "i3-auto-layout";
    homepage = "https://github.com/chmln/i3-auto-layout";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [
      mephistophiles
      perstark
    ];
    platforms = lib.platforms.linux;
  };
}
