# Release 26.05 ("Yarara", 2026.05/??) {#sec-release-26.05}

## Highlights {#sec-release-26.05-highlights}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- The default kernel package has been updated from 6.12 to 6.18. All supported kernels remain available.

## New Modules {#sec-release-26.05-new-modules}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- [Meshtastic](https://meshtastic.org), an open-source, off-grid, decentralised mesh network
  designed to run on affordable, low-power devices. Available as [services.meshtasticd]
  (#opt-services.meshtasticd.enable).

- [knot-resolver](https://www.knot-resolver.cz/) in version 6. Available as `services.knot-resolver`. A module for knot-resolver 5 was already available as `services.kresd`.

- [ImmichFrame](https://immichframe.dev/), display your photos from Immich as a digital photo frame. Available as `services.immichframe`.

- [PdfDing](https://www.pdfding.com/), manage, view and edit your PDFs seamlessly on all your devices wherever you are. Available as [services.pdfding](#opt-services.pdfding.enable).

- [reaction](https://reaction.ppom.me/), a daemon that scans program outputs for repeated patterns, and takes action. A common usage is to scan ssh and webserver logs, and to ban hosts that cause multiple authentication errors. A modern alternative to fail2ban. Available as [services.reaction](#opt-services.reaction.enable).

- [rqbit](https://github.com/ikatson/rqbit), a bittorrent client written in Rust. It has HTTP API and Web UI, and can be used as a library. Available as [services.rqbit](#opt-services.rqbit.enable).

- [Tailscale Serve](https://tailscale.com/kb/1552/tailscale-services), configure Tailscale Serve for exposing local services to your tailnet. Available as [services.tailscale.serve](#opt-services.tailscale.serve.enable).

- [qui](https://github.com/autobrr/qui), a modern alternative webUI for qBittorrent, with multi-instance support. Written in Go/React. Available as [services.qui](#opt-services.qui.enable).

- [LibreChat](https://www.librechat.ai/), open-source self-hostable ChatGPT clone with Agents and RAG APIs. Available as [services.librechat](#opt-services.librechat.enable).

- [nohang](https://github.com/hakavlad/nohang), a daemon for Linux that prevents out of memory (OOM) situations from affecting system responsiveness. Available as [services.nohang](#opt-services.nohang.enable)

- [DankMaterialShell](https://danklinux.com), a complete desktop shell for Wayland compositors built with Quickshell. Available as [programs.dms-shell](#opt-programs.dms-shell.enable).

- [dms-greeter](https://danklinux.com), a modern display manager greeter for DankMaterialShell that works with greetd and supports multiple Wayland compositors. Available as [services.displayManager.dms-greeter](#opt-services.displayManager.dms-greeter.enable).

- [dsearch](https://github.com/AvengeMedia/danksearch), a fast filesystem search service with fuzzy matching. Available as [programs.dsearch](#opt-programs.dsearch.enable).

- [Elephant](https://github.com/abenz1267/elephant), a data provider service and backend for building custom application launchers. Available as [services.elephant](#opt-services.elephant.enable).

- [Dunst](https://github.com/dunst-project/dunst), a lightweight and customizable notification daemon. Available as [services.dunst](#opt-services.dunst.enable).

- [cocoon](https://github.com/haileyok/cocoon), is a PDS (personal data server) that is a alternative to the bluesky pds. Available as [services.cocoon](#opt-services.cocoon.enable).

- [Ente Auth](https://ente.io/auth/), an open source 2FA authenticator, with end-to-end encrypted backups. Available as [programs.ente-auth](#opt-programs.ente-auth.enable).

- [Dawarich](https://dawarich.app/), a self-hostable location history tracker. Available as [services.dawarich](#opt-services.dawarich.enable).

- [Howdy](https://github.com/boltgolt/howdy), a Windows Hello™ style facial authentication program for Linux.

- [linux-enable-ir-emitter](https://github.com/EmixamPP/linux-enable-ir-emitter), a tool used to set up IR cameras, used with Howdy.

- [udp-over-tcp](https://github.com/mullvad/udp-over-tcp), a tunnel for proxying UDP traffic over a TCP stream. Available as `services.udp-over-tcp`.

- [Komodo Periphery](https://github.com/moghtech/komodo), a multi-server Docker and Git deployment agent by Komodo. Available as [services.komodo-periphery](#opt-services.komodo-periphery.enable).

- [Shoko](https://shokoanime.com), an anime management system. Available as [services.shoko](#opt-services.shoko.enable).

## Backward Incompatibilities {#sec-release-26.05-incompatibilities}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- `opentrack`, `slushload`, `synthesia`, `vtfedit`, `winbox`, `wineasio`, and `yabridge` use wineWow64Packages instead of wineWowPackages as wine versions >= 11.0 have deprecated wineWowPackages. As such, the prefixes for these packages are NOT backwards compatible and need to be regenerated with potential for data loss.

- `services.crabfit` was removed because its upstream packages are unmaintained and insecure.

- `services.tandoor-recipes` now uses a sub-directory for media files by default starting with `26.05`. Existing setups should move media files out of the data directory and adjust `services.tandoor-recipes.extraConfig.MEDIA_ROOT` accordingly. See [Migrating media files for pre 26.05 installations](#module-services-tandoor-recipes-migrating-media).

- The packages `iw` and `wirelesstools` (`iwconfig`, `iwlist`, etc.) are no longer installed implicitly if wireless networking has been enabled.

- `services.kubernetes.addons.dns.coredns` has been renamed to `services.kubernetes.addons.dns.corednsImage` and now expects a
package instead of attrs. Now, by default, nixpkgs.coredns in conjunction with dockerTools.buildImage is used, instead
of pulling the upstream container image from Docker Hub. If you want the old behavior, you can set:

```nix
{
  services.kubernetes.addons.dns.corednsImage = pkgs.dockerTools.pullImage {
    imageName = "coredns/coredns";
    imageDigest = "sha256:af8c8d35a5d184b386c4a6d1a012c8b218d40d1376474c7d071bb6c07201f47d";
    finalImageTag = "v1.12.2";
    hash = "sha256-ZgXEyxVrdskQdgg0ONJ9sboAXEEHTgNsiptk5O945c0=";
  };
}
```

- `services.stalwart-mail` has been renamed to `services.stalwart` to align with upstream re-brand as an e-mail and collaboration server. Other notable breaking changes to module:

  - `systemd.services.stalwart` owned by `stalwart:stalwart`. The `user` and `group` are configurable via `services.stalwart.user` and `services.stalwart.group`, respectively. By default, if `stateVersion` is older than `26.05`, will fallback to legacy value of `stalwart-mail` for both `user` and `group`.
  - Default value for `services.stalwart.dataDir` has changed to `/var/lib/stalwart`. If `stateVersion` is older than `26.05`, will fallback to legacy value of `/var/lib/stalwart-mail`.

- `services.oauth2-proxy.clientSecret` and `services.oauth2-proxy.cookie.secret` have been replaced with `services.oauth2-proxy.clientSecretFile` and `services.oauth2-proxy.cookie.secretFile` respectively. This was done to ensure secrets don't get made world-readable.

- Ethercalc and its associated module have been removed, as the package is unmaintained and cannot be installed from source with npm now.

- `services.cgit` before always had the git-http-backend and its "export all" setting enabled, which sidestepped any access control configured in cgit's settings. Now you have to make a decision and either enable or disable `services.cgit.gitHttpBackend.checkExportOkFiles` (or disable the git-http-backend).

- `rocmPackages_6` has been removed. `rocmPackages` has been updated to ROCm 7.x. Out of tree packages may rely on obsolete hipblas APIs or compile time constant warp size and need to be updated.

- The Bash implementation of the `nixos-rebuild` program is removed. All switchable systems now use the Python rewrite. Any prior usage of `system.rebuild.enableNg` must now be removed. If you have any outstanding issues with the new implementation, please open an issue on GitHub.

- `services.desktopManager.gnome` no longer installs the Geary e-mail client since it is not part of the GNOME [core applications](https://apps.gnome.org/) list. Geary's position in the default favorite apps section has been replaced by GNOME Text Editor. To keep it installed, add `programs.geary.enable = true;` to your configuration.

- MATE packages have been moved to top level (e.g. if you previously added `pkgs.mate.caja` to `environment.systemPackages`, you will need to change it to `pkgs.caja`).

- `walker` has been updated to 2.0.0+, which is a complete rewrite in rust.

  It now requires a running `elephant` application launcher backend service, which can be enabled using the new `services.elephpant.enable`.

  The way keybinds and actions are handled have been completely revamped. Please refer to the [default config](https://raw.githubusercontent.com/abenz1267/walker/refs/heads/master/resources/config.toml).

- Support for `reiserfs` in nixpkgs has been removed, following the removal in Linux 6.13.

- `services.tor` no longer bind mounts Unix sockets of onion services into its chroot
because it was not reliable. Users should do it themselves using either `JoinsNamespaceOf=` and Unix sockets in `/tmp`
or `BindPaths=` from a persistent parent directory of each Unix socket.
See <https://github.com/NixOS/nixpkgs/issues/481673>.

- support for `ecryptfs` in nixpkgs has been removed.

- The `networking.wireless` module has been security hardened by default: the `wpa_supplicant` daemon now runs under an unprivileged user with restricted access to the system.

  As part of these changes, `/etc/wpa_supplicant.conf` has been deprecated: the NixOS-generated configuration file is now linked to `/etc/wpa_supplicant/nixos.conf` and `/etc/wpa_supplicant/imperative.conf` has been added for imperatively configuring `wpa_supplicant` or when using [allowAuxiliaryImperativeNetworks](#opt-networking.wireless.allowAuxiliaryImperativeNetworks).

  If client certificates, keys or other files are needed, these should be stored under `/etc/wpa_supplicant` and owned by `wpa_supplicant` to ensure the daemon can read them.

  Also, the {option}`networking.wireless.userControlled.group` option has been removed since there is now a dedicated `wpa_supplicant` group to control the daemon, and {option}`networking.wireless.userControlled.enable` has been renamed to [](#opt-networking.wireless.userControlled).

  No functionality should have been impacted by these changes (including controlling via `wpa_cli`, integration with NetworkManager or connman), but if you find any problems, please open an issue on GitHub.
  If necessary, the security hardening can be reverted with [](#opt-networking.wireless.enableHardening).

  Note for NetworkManager users: before these changes NetworkManager used to spawn its own wpa_supplicant daemon, but now it relies on `networking.wireless`. So, if you had `networking.wireless.enable = false` in your configuration, you should remove that line.

- `kratos` has been updated from 1.3.1 to [25.4.0](https://github.com/ory/kratos/releases/tag/v25.4.0). Upstream switched to a new versioning scheme (year.major.minor). Notable breaking changes:

  - The `migrate sql` CLI command is now `migrate sql up`
  - OIDC registration validation errors are now placed in the `default` node group instead of `oidc`
  - Failed OIDC account linking returns HTTP 400 instead of 200

- `pdns` has been updated to version [v5.0.x](https://doc.powerdns.com/authoritative/changelog/5.0.html), which introduces breaking changes. Check out the [Upgrade Notes](https://doc.powerdns.com/authoritative/upgrading.html#to-5-0-0) for details.

- In the PowerDNS Recursor module, following the deprecation period started with NixOS 25.05, the option {option}`services.pdns-recursor.old-settings` has been removed and {option}`services.pdns-recursor.yaml-settings` consequently renamed to [](#opt-services.pdns-recursor.settings).

- `services.angrr` now uses TOML for configuration. Define policies with `services.angrr.settings` (generate TOML file) or point to a file using `services.angrr.configFile`. The legacy options `services.angrr.period`, `services.angrr.ownedOnly`, and `services.angrr.removeRoot` have been removed. See `man 5 angrr` and the description of `services.angrr.settings` options for examples and details.

- `services.homepage-dashboard.environmentFile` has been renamed to `services.homepage-dashboard.environmentFiles`, and now expects a list of strings.

- `services.pingvin-share` has been removed as the `pingvin-share.backend` package was broken and the project was archived upstream.

- `geph` package's built-in GUI `geph5-client-gui` has been [removed](https://github.com/geph-official/geph5/commit/f2221fb8386312daf2cef05483ebb353ff48bdb4) by the upstream. All users who wish to continue using the GUI should install the `gephgui-wry`, which is consistent with the official release version.

- `services.vikunja` has been updated to Vikunja [v1.0.0](https://vikunja.io/changelog/whats-new-in-vikunja-1.0.0/), which introduces multiple breaking changes.
  Notable breaking changes:
  - CORS is enabled by default. The module now sets
    `services.vikunja.settings.service.publicurl` by default. Custom overrides must ensure it is
    set or disable CORS, otherwise Vikunja will fail to start.
  - API route and response changes may affect integrations.
  - Configuration format and option changes require review of existing settings (including OpenID
    provider configuration and metrics/log settings).
  - SQLite paths are now relative to `service.rootpath` unless absolute. Startup now validates file
    storage and OAuth providers.

## Other Notable Changes {#sec-release-26.05-notable-changes}

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

- [hardware.xpadneo](#opt-hardware.xpadneo.enable) now supports configuring kernel module parameters via a freeform [settings](#opt-hardware.xpadneo.settings) option, with convenience options for [rumble attenuation](#opt-hardware.xpadneo.rumbleAttenuation) and [controller quirks](#opt-hardware.xpadneo.quirks).

- Wine has been updated to the 11.0 branch. Please check the [upstream announcement](https://gitlab.winehq.org/wine/wine/-/releases/wine-11.0) for more details.

- Cinnamon has been updated to 6.6, please check the [upstream announcement](https://www.linuxmint.com/rel_zena_whatsnew.php) for more details.

- Budgie has been updated to 10.10, please check the [upstream announcement](https://buddiesofbudgie.org/blog/budgie-10-10-released) for more details.

- `services.frp` now supports multiple instances through `services.frp.instances` to make it possible to run multiple frp clients or servers at the same time.

- `hyphen` now supports over 40 language variants through `hyphenDicts` and now allows to enable all supported languages through `hyphenDicts.all`.

- [services.resolved](#opt-services.resolved.enable) module was converted to RFC42-style settings. The moved options have also been renamed to match the upstream names. Aliases mean current configs will continue to function, but users should move to the new options as convenient.

- Support for Bluetooth audio based on `bluez-alsa` has been added to the `hardware.alsa` module. It can be enabled with the new [enableBluetooth](#opt-hardware.alsa.enableBluetooth) option.

- `services.openssh` now supports generating host SSH keys by setting `services.openssh.generateHostKeys = true` while leaving `services.openssh.enable` disabled.  This is particularly useful for systems that have no need of an SSH daemon but want SSH host keys for other purposes such as using agenix or sops-nix.

- `services.caddy` now supports setting `httpPort` and `httpsPort` and opening them in the firewall via `openFirewall`.

- `services.slurm` now supports slurmrestd usage through the `services.slurm.rest` NixOS options.

- `services.kanidm` options for server, client and unix were moved under dedicated namespaces.
  For each component `enableComponent` and `componentSettings` are now `component.enable` and
  `component.settings`. The unix module now supports using SSH keys from Kanidm via
  `services.kanidm.unix.sshIntegration = true`.

- `glibc` has been updated to version 2.42.

  This version no longer makes the stack executable when a shared library requires this. A symptom
  is an error like

  > cannot enable executable stack as shared object requires: Invalid argument

  This is usually a bug. Please consider reporting it to the software maintainers.

  In a lot of cases, the library requires the execstack by mistake only. The following workarounds exist:

  * When building the shared library in question from source, use the following linker flags to force turning off the
    executable flag:

    ```nix
    mkDerivation {
      # …

      env.NIX_LDFLAGS = "-z,noexecstack";
    }
    ```

  * If the sources are not available, the execstack-flag can be cleared with `patchelf`:

    ```
    patchelf --clear-execstack binary-only.so
    ```

  * If the shared library to be loaded actually requires an executable stack and it isn't turned
    on by the application loading it, you may force allowing that behavior by setting the
    following environment variable:

    ```
    GLIBC_TUNABLES=glibc.rtld.execstack=2
    ```

    **Do not set this globally!** This makes your setup inherently less secure.
