{
  stdenv,
  lib,
  blackmagic-desktop-video,
  kernel,
}:
stdenv.mkDerivation (finalAttrs: {
  pname = "decklink";

  # the download is a horrible curl mess. we reuse it between the kernel module
  # and desktop service, since the version of the two have to match anyways.
  # See pkgs/by-name/bl/blackmagic-desktop-video/package.nix for more.
  inherit (blackmagic-desktop-video) src version;

  KERNELDIR = "${kernel.dev}/lib/modules/${kernel.modDirVersion}/build";
  INSTALL_MOD_PATH = placeholder "out";

  nativeBuildInputs = kernel.moduleBuildDependencies;

  postUnpack =
    let
      arch = stdenv.hostPlatform.uname.processor;
    in
    ''
      tar xf Blackmagic_Desktop_Video_Linux_${finalAttrs.version}/other/${arch}/desktopvideo-${finalAttrs.version}*-${arch}.tar.gz
      bmVersion=$(ls -d $NIX_BUILD_TOP/desktopvideo-${finalAttrs.version}*-${arch}/usr/src | sed -e 's/.*desktopvideo-\([[:digit:]\.a-z]\+\).*/\1/')

      moduleRoot=$NIX_BUILD_TOP/desktopvideo-$bmVersion-${arch}/usr/src
      sourceRoot=$moduleRoot
    '';

  buildPhase = ''
    runHook preBuild
    make -C $moduleRoot/blackmagic-$bmVersion -j$NIX_BUILD_CORES
    make -C $moduleRoot/blackmagic-io-$bmVersion -j$NIX_BUILD_CORES
    runHook postBuild
  '';

  installPhase = ''
    runHook preInstall
    make -C $KERNELDIR M=$moduleRoot/blackmagic-$bmVersion modules_install
    make -C $KERNELDIR M=$moduleRoot/blackmagic-io-$bmVersion modules_install
    runHook postInstall
  '';

  meta = {
    homepage = "https://www.blackmagicdesign.com/support/family/capture-and-playback";
    maintainers = [ lib.maintainers.naxdy ];
    license = lib.licenses.unfree;
    description = "Kernel module for the Blackmagic Design Decklink cards";
    sourceProvenance = with lib.sourceTypes; [ binaryFirmware ];
    platforms = lib.platforms.linux;
  };
})
