{
  lib,
  stdenv,
  buildPythonPackage,
  fetchFromGitHub,

  # build-system
  flit-core,

  # dependencies
  aiohttp,
  fsspec,
  jinja2,
  numpy,
  psutil,
  pyparsing,
  requests,
  torch,
  tqdm,
  xxhash,

  # optional-dependencies
  # benchmark
  matplotlib,
  networkx,
  pandas,
  protobuf,
  wandb,
  # dev
  ipython,
  matplotlib-inline,
  pre-commit,
  torch-geometric,
  # full
  ase,
  graphviz,
  h5py,
  numba,
  opt-einsum,
  pynndescent,
  rdflib,
  rdkit,
  scikit-image,
  scikit-learn,
  scipy,
  statsmodels,
  sympy,
  tabulate,
  torchmetrics,
  trimesh,
  # graphgym
  pytorch-lightning,
  yacs,
  # modelhub
  huggingface-hub,
  # rag
  # pcst-fast,
  datasets,
  transformers,
  sentencepiece,
  accelerate,
  # test
  onnx,
  onnxruntime,
  pytest,
  pytest-cov-stub,

  # tests
  pytestCheckHook,
  writableTmpDirAsHomeHook,
  pythonAtLeast,
}:

buildPythonPackage (finalAttrs: {
  pname = "torch-geometric";
  version = "2.7.0";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "pyg-team";
    repo = "pytorch_geometric";
    tag = finalAttrs.version;
    hash = "sha256-xlOzpoYRoEfIRWSQoZbEPvUW43AMr3rCgIYnxwG/z3A=";
  };

  build-system = [
    flit-core
  ];

  dependencies = [
    aiohttp
    fsspec
    jinja2
    numpy
    psutil
    pyparsing
    requests
    torch
    tqdm
    xxhash
  ];

  optional-dependencies = {
    benchmark = [
      matplotlib
      networkx
      pandas
      protobuf
      wandb
    ];
    dev = [
      ipython
      matplotlib-inline
      pre-commit
      torch-geometric
    ];
    full = [
      ase
      # captum
      graphviz
      h5py
      matplotlib
      networkx
      numba
      opt-einsum
      pandas
      # pgmpy
      pynndescent
      # pytorch-memlab
      rdflib
      rdkit
      scikit-image
      scikit-learn
      scipy
      statsmodels
      sympy
      tabulate
      torch-geometric
      torchmetrics
      trimesh
    ];
    graphgym = [
      protobuf
      pytorch-lightning
      yacs
    ];
    modelhub = [
      huggingface-hub
    ];
    rag = [
      # pcst-fast (unpackaged)
      datasets
      transformers
      pandas
      sentencepiece
      accelerate
      torchmetrics
    ];
    test = [
      onnx
      onnxruntime
      # onnxscript (unpackaged)
      pytest
      pytest-cov-stub
    ];
  };

  pythonImportsCheck = [ "torch_geometric" ];

  nativeCheckInputs = [
    pytestCheckHook
    writableTmpDirAsHomeHook
  ];

  pytestFlags = [
    # DeprecationWarning: Failing to pass a value to the 'type_params' parameter of
    # 'typing._eval_type' is deprecated, as it leads to incorrect behaviour when calling
    # typing._eval_type on a stringified annotation that references a PEP 695 type parameter.
    # It will be disallowed in Python 3.15.
    "-Wignore::DeprecationWarning"
  ];

  disabledTests = [
    # RuntimeError: addmm: computation on CPU is not implemented for SparseCsr + SparseCsr @ SparseCsr without MKL.
    # PyTorch built with MKL has better support for addmm with sparse CPU tensors.
    "test_asap"
    "test_graph_unet"

    # AttributeError: type object 'Any' has no attribute '_name'
    "test_type_repr"

    # AttributeError: module 'torch.fx._symbolic_trace' has no attribute 'List'
    "test_set_clear_mask"
    "test_sequential_to_hetero"
    "test_to_fixed_size"
    "test_to_hetero_basic"
    "test_to_hetero_with_gcn"
    "test_to_hetero_with_basic_model"
    "test_to_hetero_and_rgcn_equal_output"
    "test_graph_level_to_hetero"
    "test_hetero_transformer_self_loop_error"
    "test_to_hetero_validate"
    "test_to_hetero_on_static_graphs"
    "test_to_hetero_with_bases"
    "test_to_hetero_with_bases_and_rgcn_equal_output"
    "test_to_hetero_with_bases_validate"
    "test_to_hetero_with_bases_on_static_graphs"
    "test_to_hetero_with_bases_save"

    # Failed: DID NOT WARN.
    "test_to_hetero_validate"
    "test_to_hetero_with_bases_validate"

    # Failed: DID NOT RAISE
    "test_scatter_backward"
  ]
  ++ lib.optionals stdenv.hostPlatform.isDarwin [
    # This test uses `torch.jit` which might not be working on darwin:
    # RuntimeError: required keyword attribute 'value' has the wrong type
    "test_traceable_my_conv_with_self_loops"

    # RuntimeError: no response from torch_shm_manager
    "test_data_loader"
    "test_data_share_memory"
    "test_dataloader"
    "test_edge_index_dataloader"
    "test_heterogeneous_dataloader"
    "test_index_dataloader"
    "test_multiprocessing"
    "test_share_memory"
    "test_storage_tensor_methods"

    # NotImplementedError: The operator 'aten::logspace.out' is not currently implemented for the MPS device.
    "test_positional_encoding"
  ]
  ++ lib.optionals (pythonAtLeast "3.13") [
    # RuntimeError: Dynamo is not supported on Python 3.13+
    "test_compile"

    # RuntimeError: Python 3.13+ not yet supported for torch.compile
    "test_compile_graph_breaks"
    "test_compile_multi_aggr_sage_conv"
    "test_compile_hetero_conv_graph_breaks"

    # AttributeError: module 'typing' has no attribute 'io'. Did you mean: 'IO'?
    "test_packaging"

    # RuntimeError: Boolean value of Tensor with more than one value is ambiguous
    "test_feature_store"
  ]
  ++ lib.optionals (pythonAtLeast "3.14") [
    # TypeError: cannot pickle 'sqlite3.Connection' object
    "test_dataloader_on_disk_dataset"

    # AssertionError: assert False
    # assert utils.supports_bipartite_graphs('SAGEConv')
    "test_gnn_cheatsheet"

    # AttributeError: readonly attribute
    "test_fill_config_store"
    "test_register"
    "test_to_dataclass"

    # AttributeError: '...' object has no attribute '__annotations__'
    "test_degree_scaler_aggregation"
    "test_explain_message"
    "test_fused_aggregation"
    "test_gcn_conv_with_decomposed_layers"
    "test_hetero_dict_linear_jit"
    "test_hetero_linear_basic"
    "test_jit"
    "test_mlp"
    "test_multi_agg"
    "test_my_commented_conv"
    "test_my_conv_jit"
    "test_my_conv_jit_save"
    "test_my_default_arg_conv"
    "test_my_edge_conv_jit"
    "test_my_kwargs_conv"
    "test_my_multiple_aggr_conv_jit"
    "test_pickle"
    "test_sequential_jit"
    "test_torch_script"
    "test_traceable_my_conv_with_self_loops"
    "test_tuple_output_jit"
  ];

  disabledTestPaths =
    lib.optionals stdenv.hostPlatform.isDarwin [
      # MPS (Metal) tests are failing when using `libtorch_cpu`.
      # Crashes in `structured_cat_out_mps`
      "test/nn/models/test_deep_graph_infomax.py::test_infomax_predefined_model[mps]"
      "test/nn/norm/test_instance_norm.py::test_instance_norm[True-mps]"
      "test/nn/norm/test_instance_norm.py::test_instance_norm[False-mps]"
      "test/nn/norm/test_layer_norm.py::test_layer_norm[graph-True-mps]"
      "test/nn/norm/test_layer_norm.py::test_layer_norm[graph-False-mps]"
      "test/nn/norm/test_layer_norm.py::test_layer_norm[node-True-mps]"
      "test/nn/norm/test_layer_norm.py::test_layer_norm[node-False-mps]"
      "test/utils/test_scatter.py::test_group_cat[mps]"
    ]
    ++ lib.optionals (pythonAtLeast "3.14") [
      # AttributeError: '...' object has no attribute '__annotations__'
      "test/nn/aggr/test_aggr_utils.py"
    ];

  meta = {
    description = "Graph Neural Network Library for PyTorch";
    homepage = "https://github.com/pyg-team/pytorch_geometric";
    changelog = "https://github.com/pyg-team/pytorch_geometric/blob/${finalAttrs.src.tag}/CHANGELOG.md";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ GaetanLepage ];
  };
})
