{
  lib,
  buildPythonPackage,
  fetchFromGitHub,
  pytestCheckHook,
  tinydb,
}:

buildPythonPackage rec {
  pname = "tinyrecord";
  version = "0.2.0";
  format = "setuptools";

  src = fetchFromGitHub {
    owner = "eugene-eeo";
    repo = "tinyrecord";
    tag = "v${version}";
    hash = "sha256-mF4hpHuNyiQ5DurRnyLck5e/Vp26GCLkhD8eeSB4NYs=";
  };

  nativeCheckInputs = [
    pytestCheckHook
    tinydb
  ];

  enabledTestPaths = [ "tests.py" ];

  pythonImportsCheck = [ "tinyrecord" ];

  meta = {
    description = "Transaction support for TinyDB";
    homepage = "https://github.com/eugene-eeo/tinyrecord";
    changelog = "https://github.com/eugene-eeo/tinyrecord/releases/tag/v${version}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ nickcao ];
  };
}
