{
  lib,
  buildPythonPackage,
  fetchFromGitHub,
}:

buildPythonPackage rec {
  pname = "syslog-rfc5424-formatter";
  version = "1.2.3";
  format = "setuptools";

  src = fetchFromGitHub {
    owner = "easypost";
    repo = "syslog-rfc5424-formatter";
    tag = "v${version}";
    hash = "sha256-dvRSOMXRmZf0vEEyX6H7OBSfo/PgyOLKuDS8X6g4qe0=";
  };

  # Tests are not picked up, review later again
  doCheck = false;

  pythonImportsCheck = [ "syslog_rfc5424_formatter" ];

  meta = {
    description = "Python logging formatter for emitting RFC5424 Syslog messages";
    homepage = "https://github.com/easypost/syslog-rfc5424-formatter";
    license = with lib.licenses; [ isc ];
    maintainers = with lib.maintainers; [ fab ];
  };
}
