{
  lib,
  fetchFromGitHub,
  buildPythonPackage,
  hatchling,
  pyqt6,
  poppler-qt5,
  pycups,
}:

buildPythonPackage rec {
  pname = "qpageview";
  version = "1.0.2";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "frescobaldi";
    repo = "qpageview";
    tag = "v${version}";
    hash = "sha256-bUZI3ML3MN+0KLQxrPfQOC7lxdpvl3sxJ4zi0phsiCw=";
  };

  build-system = [ hatchling ];

  dependencies = [
    pyqt6
    poppler-qt5
    pycups
  ];

  doCheck = false; # no tests

  pythonImportsCheck = [ "qpageview" ];

  meta = {
    description = "Page-based viewer widget for Qt5/PyQt5";
    homepage = "https://github.com/frescobaldi/qpageview";
    changelog = "https://github.com/frescobaldi/qpageview/blob/${src.tag}/ChangeLog";
    license = lib.licenses.gpl3Only;
    maintainers = with lib.maintainers; [ camillemndn ];
  };
}
