{
  lib,
  buildPythonPackage,
  fetchFromGitHub,
  gmpy2,
  isPyPy,
  setuptools,
  pytestCheckHook,

  # Reverse dependency
  sage,
}:

buildPythonPackage rec {
  pname = "mpmath";
  version = "1.3.0";
  format = "setuptools";

  src = fetchFromGitHub {
    owner = "mpmath";
    repo = "mpmath";
    tag = version;
    hash = "sha256-9BGcaC3TyolGeO65/H42T/WQY6z5vc1h+MA+8MGFChU=";
  };

  nativeBuildInputs = [ setuptools ];

  optional-dependencies = {
    gmpy = lib.optionals (!isPyPy) [ gmpy2 ];
  };

  passthru.tests = {
    inherit sage;
  };

  nativeCheckInputs = [ pytestCheckHook ];

  meta = {
    homepage = "https://mpmath.org/";
    description = "Pure-Python library for multiprecision floating arithmetic";
    license = lib.licenses.bsd3;
    maintainers = with lib.maintainers; [ lovek323 ];
    platforms = lib.platforms.unix;
  };
}
