{
  lib,
  buildPythonPackage,
  numpy,
  pkgs,
  pybind11,
}:

buildPythonPackage {
  inherit (pkgs.fasttext) pname version src;

  format = "setuptools";

  buildInputs = [ pybind11 ];

  pythonImportsCheck = [ "fasttext" ];

  propagatedBuildInputs = [ numpy ];

  preBuild = ''
    HOME=$TMPDIR
  '';

  meta = {
    description = "Python module for text classification and representation learning";
    homepage = "https://fasttext.cc/";
    license = lib.licenses.mit;
    maintainers = [ ];
  };
}
