{
  lib,
  fetchFromGitHub,
  buildPythonPackage,
  setuptools,
  websockets,
  pytest-asyncio_0,
  pytestCheckHook,
}:

buildPythonPackage rec {
  pname = "aiorpcx";
  version = "0.25.0";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "kyuupichan";
    repo = "aiorpcX";
    tag = version;
    hash = "sha256-mFg9mWrlnfXiQpgZ1rxvUy9TBfwy41XEKmsCf2nvxGo=";
  };

  build-system = [ setuptools ];

  optional-dependencies.ws = [ websockets ];

  nativeCheckInputs = [
    pytest-asyncio_0
    pytestCheckHook
  ]
  ++ lib.concatAttrValues optional-dependencies;

  disabledTests = [
    # network access
    "test_create_connection_resolve_good"
  ];

  pythonImportsCheck = [ "aiorpcx" ];

  meta = {
    description = "Transport, protocol and framing-independent async RPC client and server implementation";
    homepage = "https://github.com/kyuupichan/aiorpcX";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ prusnak ];
  };
}
