{
  lib,
  mkCoqDerivation,
  coq,
  stdlib,
  version ? null,
}:

let
  owner = "lukaszcz";
  repo = "coqhammer";
  case = case: out: { inherit case out; };
  defaultVersion =

    lib.switch coq.coq-version [
      (case "9.1" "1.3.2+9.1")
      (case "9.0" "1.3.2+9.0")
      (case "8.20" "1.3.2+8.20")
      (case "8.19" "1.3.2+8.19")
      (case "8.18" "1.3.2+8.18")
      (case "8.17" "1.3.2+8.17")
      (case "8.16" "1.3.2+8.16")
    ] null;

  release = {
    "1.3.2+9.1".sha256 = "sha256-tf+Hrfv/ZrLXryTjJchvLfydxzjkXB2hbL7P280Clzw=";
    "1.3.2+9.0".sha256 = "sha256-/UHtK9fjpHTbra4/Cnsjt8fg1fvxx7U6kGjQPm15NwM=";
    "1.3.2+8.20".sha256 = "sha256-RuX2aInSjwebs/aEOoisNxqcIPqDA2kWehN9tFYqOx4=";
    "1.3.2+8.19".sha256 = "sha256-Zd7piAWlKPAZKEz7HVWxhnzOLbA/eR9C/E0T298MJVY=";
    "1.3.2+8.18".sha256 = "sha256-D+tQ+1YrSbbqc54U5UlxW1Hhly49TB2pu1LEPL2Eo64=";
    "1.3.2+8.17".sha256 = "sha256-2fw66z3yFKs5g+zNCeYXiEyxPzjUr+lGDciiQiuuMAs=";
    "1.3.2+8.16".sha256 = "sha256-+j2Mg9n4heXbhjRaqiTQfgBxRqfw6TPYbIuCdhu8OeE=";
  };

  releaseRev = v: "refs/tags/v${v}";

in

mkCoqDerivation {
  inherit version;
  pname = "coq-hammer-tactics";

  inherit
    owner
    repo
    defaultVersion
    release
    releaseRev
    ;
  passthru = {
    inherit
      owner
      repo
      defaultVersion
      release
      releaseRev
      ;
  };

  propagatedBuildInputs = [ stdlib ];

  mlPlugin = true;

  buildFlags = [ "tactics" ];
  installTargets = [ "install-tactics" ];

  meta = {
    description = "Reconstruction tactics for the hammer for Coq";
    homepage = "https://github.com/lukaszcz/coqhammer";
    license = lib.licenses.lgpl21;
    maintainers = [ lib.maintainers.vbgl ];
  };
}
