{
  lib,
  stdenv,
  replaceVars,
  fetchFromGitHub,
  taskwarrior2,
  gettext,
  runtimeShell,
}:

stdenv.mkDerivation rec {
  pname = "gnome-shell-extension-taskwhisperer";
  version = "20";

  src = fetchFromGitHub {
    owner = "cinatic";
    repo = "taskwhisperer";
    rev = "v${version}";
    sha256 = "sha256-UVBLFXsbOPRXC4P5laZ82Rs08yXnNnzJ+pp5fbx6Zqc=";
  };

  nativeBuildInputs = [
    gettext
  ];

  buildInputs = [
    taskwarrior2
  ];

  passthru = {
    extensionUuid = "taskwhisperer-extension@infinicode.de";
    extensionPortalSlug = "taskwhisperer";
  };

  makeFlags = [
    "INSTALLBASE=${placeholder "out"}/share/gnome-shell/extensions"
  ];

  patches = [
    (replaceVars ./fix-paths.patch {
      task = "${taskwarrior2}/bin/task";
    })
  ];

  meta = {
    description = "GNOME Shell TaskWarrior GUI";
    license = lib.licenses.gpl3Plus;
    maintainers = [ ];
    homepage = "https://github.com/cinatic/taskwhisperer";
  };
}
