{
  lib,
  localSystem,
  crossSystem,
  config,
  overlays,
  crossOverlays ? [ ],
}:

assert crossSystem == localSystem;

let
  bootStages = import ../. {
    inherit
      lib
      localSystem
      crossSystem
      overlays
      ;
    # Remove config.replaceStdenv to ensure termination.
    config = removeAttrs config [ "replaceStdenv" ];
  };

in
bootStages
++ [

  # Additional stage, built using custom stdenv
  (vanillaPackages: {
    inherit config overlays;
    stdenv =
      assert vanillaPackages.stdenv.hostPlatform == localSystem;
      assert vanillaPackages.stdenv.targetPlatform == localSystem;
      config.replaceStdenv { pkgs = vanillaPackages; };
  })

]
