{
  lib,
  stdenv,
  buildPythonPackage,
  fetchFromGitHub,

  # build-system
  cmake,
  cython,
  ninja,
  pkg-config,
  scikit-build-core,

  # native dependencies
  c-blosc2,

  # dependencies
  msgpack,
  ndindex,
  numexpr,
  numpy,
  platformdirs,
  py-cpuinfo,
  requests,

  # tests
  psutil,
  pytestCheckHook,
  torch,
  runTorchTests ? lib.meta.availableOn stdenv.hostPlatform torch,
}:

buildPythonPackage rec {
  pname = "blosc2";
  version = "3.11.1";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "Blosc";
    repo = "python-blosc2";
    tag = "v${version}";
    hash = "sha256-n+DSBzb3XXzMEqx8ApFLymU1/IPZTcEFgRarvmYkZVY=";
  };

  nativeBuildInputs = [
    cmake
    ninja
    pkg-config
  ];

  dontUseCmakeConfigure = true;
  env.CMAKE_ARGS = lib.cmakeBool "USE_SYSTEM_BLOSC2" true;

  build-system = [
    cython
    numpy
    scikit-build-core
  ];

  buildInputs = [ c-blosc2 ];

  dependencies = [
    msgpack
    ndindex
    numexpr
    numpy
    platformdirs
    py-cpuinfo
    requests
  ];

  nativeCheckInputs = [
    psutil
    pytestCheckHook
  ]
  ++ lib.optionals runTorchTests [ torch ];

  disabledTests = [
    # attempts external network requests
    "test_with_remote"
  ];

  passthru.c-blosc2 = c-blosc2;

  meta = with lib; {
    description = "Python wrapper for the extremely fast Blosc2 compression library";
    homepage = "https://github.com/Blosc/python-blosc2";
    changelog = "https://github.com/Blosc/python-blosc2/releases/tag/${src.tag}";
    license = licenses.bsd3;
    maintainers = with maintainers; [ ris ];
  };
}
