{
  lib,
  stdenv,
  fetchFromGitLab,
  meson,
  ninja,
  pkg-config,
  cargo,
  rustc,
  rustPlatform,
  blueprint-compiler,
  glib,
  gtk4,
  libadwaita,
  gtksourceview5,
  wrapGAppsHook4,
  desktop-file-utils,
  nix-update-script,
}:

stdenv.mkDerivation (finalAttrs: {
  pname = "textpieces";
  version = "4.3.1";

  src = fetchFromGitLab {
    owner = "liferooter";
    repo = "textpieces";
    tag = "${finalAttrs.version}";
    hash = "sha256-BUhcPnvi6cuhaYYNZV9pvOLH/cIV3t7ncpG55fBjqwo=";
  };

  cargoDeps = rustPlatform.fetchCargoVendor {
    inherit (finalAttrs) pname version src;
    hash = "sha256-bJKhakxHBhhqvgrFwEgaSNDI7cDaYQ+2SW/gSZzRvK0=";
  };

  nativeBuildInputs = [
    meson
    ninja
    pkg-config
    cargo
    rustc
    rustPlatform.cargoSetupHook
    blueprint-compiler
    wrapGAppsHook4
    desktop-file-utils
  ];

  buildInputs = [
    glib
    gtk4
    libadwaita
    gtksourceview5
  ];

  passthru = {
    updateScript = nix-update-script { };
  };

  meta = {
    description = "Swiss knife of text processing";
    longDescription = ''
      A small tool for quick text transformations such as
      checksums, encoding, decoding and so on.
    '';
    homepage = "https://gitlab.com/liferooter/textpieces";
    mainProgram = "textpieces";
    license = with lib.licenses; [
      gpl3Plus
      # and
      cc0
    ];
    platforms = lib.platforms.linux;
    maintainers = with lib.maintainers; [
      zendo
      liferooter
    ];
    teams = [ lib.teams.gnome-circle ];
  };
})
