{
  lib,
  stdenv,
  fetchFromGitHub,
  pkg-config,
  cmake,
  glib,
  boost,
  libsigrok,
  libserialport,
  libzip,
  libftdi1,
  hidapi,
  glibmm,
  python3,
  bluez,
  pcre,
  libsForQt5,
  desktopToDarwinBundle,
  qt5,
}:

stdenv.mkDerivation {
  pname = "smuview";
  version = "0.0.5-unstable-2023-04-12";

  src = fetchFromGitHub {
    owner = "knarfS";
    repo = "smuview";
    rev = "a5ffb66287b725ebcdecc1eab04a4574c8585f66";
    hash = "sha256-WH8X75yk0aMivbBBOyODcM1eBWwa5UO/3nTaKV1LCGs=";
  };

  nativeBuildInputs = [
    cmake
    pkg-config
    qt5.wrapQtAppsHook
  ]
  ++ lib.optional stdenv.hostPlatform.isDarwin desktopToDarwinBundle;

  buildInputs = [
    glib
    boost
    libsigrok
    libserialport
    libzip
    libftdi1
    hidapi
    glibmm
    python3
    pcre
    libsForQt5.qwt
  ]
  ++ lib.optionals stdenv.hostPlatform.isLinux [ bluez ];

  postPatch = ''
    substituteInPlace external/pybind11_2.11_dev1/CMakeLists.txt \
      --replace-fail "cmake_minimum_required(VERSION 3.4)" "cmake_minimum_required(VERSION 3.10)"
    substituteInPlace external/QtFindReplaceDialog/dialogs/CMakeLists.txt \
      --replace-fail "cmake_minimum_required(VERSION 3.1)" "cmake_minimum_required(VERSION 3.10)"
    substituteInPlace manual/CMakeLists.txt \
      --replace-fail "cmake_minimum_required(VERSION 2.8.12)" "cmake_minimum_required(VERSION 3.10)"
  '';

  meta = with lib; {
    description = "Qt based source measure unit GUI for sigrok";
    mainProgram = "smuview";
    longDescription = "SmuView is a GUI for sigrok that supports power supplies, electronic loads and all sorts of measurement devices like multimeters, LCR meters and so on";
    homepage = "https://github.com/knarfS/smuview";
    license = licenses.gpl3Plus;
    maintainers = with maintainers; [ vifino ];
    platforms = platforms.unix;
  };
}
