{
  lib,
  fetchFromGitHub,
  python3,
}:

python3.pkgs.buildPythonApplication rec {
  pname = "pentestgpt";
  version = "unstable-2023-06-27";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "GreyDGL";
    repo = "PentestGPT";
    rev = "e63a91f466a035e036827e8f492bc47c5c1135af";
    hash = "sha256-m0R/kMmbr5Ixuqvw6ZRoaAGCnI3j86Iwk4+TYqv0WbU=";
  };

  build-system = with python3.pkgs; [ setuptools ];

  pythonRelaxDeps = [ "playwright" ];
  pythonRemoveDeps = [
    "beautifulsoup4"
    "black"
    "pytest"
  ];

  dependencies = with python3.pkgs; [
    beautifulsoup4
    colorama
    google
    langchain
    loguru
    openai
    playwright
    prompt-toolkit
    pycookiecheat
    pyyaml
    requests
    rich
    sqlmap
    tiktoken
  ];

  # Tests require network access
  doCheck = false;

  pythonImportsCheck = [
    "pentestgpt"
  ];

  meta = {
    description = "GPT-empowered penetration testing tool";
    homepage = "https://github.com/GreyDGL/PentestGPT";
    changelog = "https://github.com/GreyDGL/PentestGPT/releases/tag/v${version}";
    license = lib.licenses.mit;
    maintainers = with lib.maintainers; [ fab ];
  };
}
