{
  lib,
  stdenv,
  fetchFromGitHub,
  fetchpatch,
  pkg-config,
  which,
  frei0r,
  opencolorio,
  ffmpeg_6,
  cmake,
  openimageio,
  openexr,
  portaudio,
  imath,
  qt6,
  fmt_10,
}:

let
  # https://github.com/olive-editor/olive/issues/2284
  # we patch support for 2.3+, but 2.5 fails
  openimageio' = (openimageio.override { fmt = fmt_10; }).overrideAttrs (old: rec {
    version = "2.4.15.0";
    src = (
      old.src.override {
        tag = "v${version}";
        hash = "sha256-I2/JPmUBDb0bw7qbSZcAkYHB2q2Uo7En7ZurMwWhg/M=";
      }
    );

    # robin-map headers require c++17
    cmakeFlags = (old.cmakeFlags or [ ]) ++ [ (lib.cmakeFeature "CMAKE_CXX_STANDARD" "17") ];
  });
in

stdenv.mkDerivation {
  pname = "olive-editor";
  version = "0.1.2-unstable-2023-06-12";

  src = fetchFromGitHub {
    fetchSubmodules = true;
    owner = "olive-editor";
    repo = "olive";
    rev = "2036fffffd0e24b7458e724b9084ae99c9507c64";
    hash = "sha256-qee9/WTvTy5jWLowvZJOwAjrqznRhJR+u9dYsnCN/Qs=";
  };

  cmakeFlags = [
    "-DBUILD_QT6=1"
  ];

  patches = [
    (fetchpatch {
      # Taken from https://github.com/olive-editor/olive/pull/2294.
      name = "olive-editor-openimageio-2.3-compat.patch";
      url = "https://github.com/olive-editor/olive/commit/311eeb72944f93f873d1cd1784ee2bf423e1e7c2.patch";
      hash = "sha256-lswWn4DbXGH1qPvPla0jSgUJQXuqU7LQGHIPoXAE8ag=";
    })

    # Fix build of `kddockwidgets` with qt6-6.10, adapted from:
    # https://github.com/KDAB/KDDockWidgets/pull/615
    # https://github.com/KDAB/KDDockWidgets/commit/f2b50fff29bd4b49acdfed3ed8fc42eb0a502032
    ./olive-editor-kddockwidgets-fix-build-with-qt-6_10.patch
  ];

  # https://github.com/olive-editor/olive/issues/2200
  postPatch = ''
    substituteInPlace ./app/node/project/serializer/serializer230220.cpp \
      --replace 'QStringRef' 'QStringView'
  '';

  nativeBuildInputs = [
    pkg-config
    which
    cmake
    qt6.wrapQtAppsHook
  ];

  buildInputs = [
    ffmpeg_6
    frei0r
    opencolorio
    openimageio'
    imath
    openexr
    portaudio
    qt6.qtwayland
    qt6.qtmultimedia
    qt6.qttools
  ];

  meta = {
    description = "Professional open-source NLE video editor";
    homepage = "https://www.olivevideoeditor.org/";
    downloadPage = "https://www.olivevideoeditor.org/download.php";
    license = lib.licenses.gpl3;
    maintainers = with lib.maintainers; [ balsoft ];
    platforms = lib.platforms.unix;
    # never built on aarch64-darwin since first introduction in nixpkgs
    broken = stdenv.hostPlatform.isDarwin && stdenv.hostPlatform.isAarch64;
    mainProgram = "olive-editor";
  };
}
