#!/usr/bin/env nix-shell
#! nix-shell -i bash --pure -p cacert curl yq nix

set -euo pipefail

cd "$(readlink -e "$(dirname "${BASH_SOURCE[0]}")")"

x86_64_linux_info=$(curl -fsS "https://dl.fastmailcdn.com/desktop/production/linux/x64/latest-linux.yml")
aarch64_darwin_info=$(curl -fsS "https://dl.fastmailcdn.com/desktop/production/mac/arm64/latest-mac.yml")

x86_64_linux_version=$(yq -r '.version' <<<"$x86_64_linux_info")
aarch64_darwin_version=$(yq -r '.version' <<<"$aarch64_darwin_info")

x86_64_linux_url="https://dl.fastmailcdn.com/desktop/production/linux/x64/$(yq -r '.path' <<<"$x86_64_linux_info")"
aarch64_darwin_url="https://dl.fastmailcdn.com/desktop/production/mac/arm64/$(yq -r '.path' <<<"$aarch64_darwin_info")"

x86_64_linux_hash=$(nix-hash --type sha512 --to-sri "$(yq -r '.sha512' <<<"$x86_64_linux_info")")
aarch64_darwin_hash=$(nix-hash --type sha512 --to-sri "$(yq -r '.sha512' <<<"$aarch64_darwin_info")")

cat >sources.nix <<EOF
# Generated by ./update.sh - do not update manually!
# Last updated: $(date +%F)
{ fetchurl, fetchzip }:
{
  aarch64-darwin = {
    version = "$aarch64_darwin_version";
    src = fetchurl {
      url = "$aarch64_darwin_url";
      hash = "$aarch64_darwin_hash";
    };
  };
  x86_64-linux = {
    version = "$x86_64_linux_version";
    src = fetchurl {
      url = "$x86_64_linux_url";
      hash = "$x86_64_linux_hash";
    };
  };
}
EOF
