{
  lib,
  stdenv,
  fetchFromGitLab,
  makeWrapper,
}:
stdenv.mkDerivation (finalAttrs: {
  pname = "exploitdb";
  version = "2025-11-01";

  src = fetchFromGitLab {
    owner = "exploit-database";
    repo = "exploitdb";
    tag = finalAttrs.version;
    hash = "sha256-MXWP7YOv4JAIKerAGuSeiAiQ98sRU6mZ1ZQSJBPCZQs=";
  };

  nativeBuildInputs = [ makeWrapper ];

  installPhase = ''
    runHook preInstall
    mkdir -p $out/bin $out/share
    cp --recursive . $out/share/exploitdb

    substituteInPlace $out/share/exploitdb/.searchsploit_rc \
      --replace-fail 'path_array+=("/opt/exploitdb")' 'path_array+=("'$out'/share/exploitdb")' \
      --replace-fail 'path_array+=("/opt/exploitdb-papers")' 'path_array+=("'$out'/share/exploitdb")'

    makeWrapper $out/share/exploitdb/searchsploit $out/bin/searchsploit
    runHook postInstall
  '';

  meta = {
    description = "Archive of public exploits and corresponding vulnerable software";
    homepage = "https://gitlab.com/exploit-database/exploitdb";
    license = with lib.licenses; [
      gpl2Plus
      gpl3Plus
      mit
    ];
    maintainers = with lib.maintainers; [
      applePrincess
      fab
    ];
    mainProgram = "searchsploit";
    platforms = lib.platforms.unix;
  };
})
