{
  lib,
  fetchFromGitHub,
  python3,
}:

python3.pkgs.buildPythonApplication rec {
  pname = "cve-prioritizer";
  version = "1.10.1";
  pyproject = true;

  src = fetchFromGitHub {
    owner = "TURROKS";
    repo = "CVE_Prioritizer";
    tag = "v${version}";
    hash = "sha256-Yy5jVpxb3e2lCpxMaxDdXBGh8by5lmGi+G+kJguA3AA=";
  };

  build-system = with python3.pkgs; [ setuptools ];

  dependencies = with python3.pkgs; [
    click
    pandas
    python-dotenv
    requests
    termcolor
  ];

  # Project has no tests
  doCheck = false;

  pythonImportsCheck = [ "cve_prioritizer" ];

  meta = {
    description = "Vulnerability patching with CVSS, EPSS, and CISA's Known Exploited Vulnerabilities";
    homepage = "https://github.com/TURROKS/CVE_Prioritizer";
    changelog = "https://github.com/TURROKS/CVE_Prioritizer/releases/tag/${src.tag}";
    license = lib.licenses.bsd3;
    maintainers = with lib.maintainers; [ fab ];
    mainProgram = "cve-prioritizer";
  };
}
