{
  stdenvNoCC,
  lib,
  fetchFromGitHub,
  makeWrapper,
  php83,
  nixosTests,
}:

stdenvNoCC.mkDerivation rec {
  pname = "icingaweb2";
  version = "2.12.5";

  src = fetchFromGitHub {
    owner = "Icinga";
    repo = "icingaweb2";
    rev = "v${version}";
    hash = "sha256-g55TR7rgWnxNa1OQXOaLAPg3ijtx1u3mqxAxcMLhcB4=";
  };

  nativeBuildInputs = [ makeWrapper ];

  installPhase = ''
    mkdir -p $out/share
    cp -ra application bin etc library modules public schema $out
    cp -ra doc $out/share

    wrapProgram $out/bin/icingacli --prefix PATH : "${lib.makeBinPath [ php83 ]}"
  '';

  passthru.tests = { inherit (nixosTests) icingaweb2; };

  meta = with lib; {
    description = "Webinterface for Icinga 2";
    longDescription = ''
      A lightweight and extensible web interface to keep an eye on your environment.
      Analyse problems and act on them.
    '';
    homepage = "https://www.icinga.com/products/icinga-web-2/";
    license = licenses.gpl2Plus;
    teams = [ teams.helsinki-systems ];
    mainProgram = "icingacli";
    platforms = platforms.all;
  };
}
