{
  lib,
  buildPythonPackage,
  fetchPypi,
  gitpython,
  requests,
  setuptools,
}:

buildPythonPackage rec {
  pname = "pyexploitdb";
  version = "0.2.103";
  pyproject = true;

  src = fetchPypi {
    inherit pname version;
    hash = "sha256-UAR3S0Tpo1C6a8YcNjoncPWEklwCsSC+T8E5s5rgaw8=";
  };

  build-system = [ setuptools ];

  dependencies = [
    gitpython
    requests
  ];

  # Module has no tests
  doCheck = false;

  pythonImportsCheck = [ "pyExploitDb" ];

  meta = with lib; {
    description = "Library to fetch the most recent exploit-database";
    homepage = "https://github.com/Hackman238/pyExploitDb";
    changelog = "https://github.com/Hackman238/pyExploitDb/blob/master/ChangeLog.md";
    license = licenses.gpl3Plus;
    maintainers = with maintainers; [ fab ];
  };
}
