{
  lib,
  config,
  ...
}:
{
  imports = [
    ./disk.nix
    ./firmware.nix
    ./keyboard.nix
    ./networking
    ./system.nix
    ./virtualisation.nix
  ];

  meta.maintainers = with lib.maintainers; [ mic92 ];

  options.hardware.facter = with lib; {
    report = mkOption {
      type = types.attrsOf types.anything;
      default =
        if config.hardware.facter.reportPath == null then
          { }
        else
          builtins.fromJSON (builtins.readFile config.hardware.facter.reportPath);
      defaultText = "A JSON import from config.hardware.facter.reportPath (if not null), {} otherwise.";
      description = ''
        Hardware report data generated by nixos-facter.

        See <https://nix-community.github.io/nixos-facter/> for more information.
      '';
    };

    reportPath = mkOption {
      type = types.nullOr types.path;
      default = null;
      description = ''
        Path to a hardware report generated by nixos-facter.

        To generate a report, run the following as root:
        ```
        nix-shell -p nixos-facter --run nixos-facter > facter.json
        ```

        See <https://nix-community.github.io/nixos-facter/> for more information.
      '';
    };
  };
}
